# SMG Player Configuration Update Script
# Bu script SMG Player'ı durdurur, config dosyasını günceller ve yeniden başlatır

# Log fonksiyonu
function Write-Log {
    param([string]$Message)
    $timestamp = Get-Date -Format "yyyy-MM-dd HH:mm:ss"
    Write-Host "[$timestamp] $Message" -ForegroundColor Green
    Add-Content -Path "C:\SMG_Update_Log.txt" -Value "[$timestamp] $Message"
}

try {
    Write-Log "SMG Player config update başlatılıyor..."
    
    # Config dosyası yolu
    $configPath = "C:\smg\smgplayer\config.ini"
    
    # Dosya var mı kontrol et
    if (-not (Test-Path $configPath)) {
        Write-Log "HATA: Config dosyası bulunamadı: $configPath"
        exit 1
    }
    
    Write-Log "Config dosyası okunuyor: $configPath"
    
    # Config dosyasını oku
    $content = Get-Content $configPath
    
    # Backup oluştur
    $backupPath = "$configPath.backup_$(Get-Date -Format 'yyyyMMdd_HHmmss')"
    Copy-Item $configPath $backupPath
    Write-Log "Backup oluşturuldu: $backupPath"
    
    # URL'leri güncelle
    Write-Log "URL'ler güncelleniyor..."
    $content = $content -replace 'serviceUrl=.*', 'serviceUrl=https://kigili.smg.com.tr/smgpush'
    $content = $content -replace 'downloadURL=.*', 'downloadURL=http://kigilicdn.smg.com.tr/'
    $content = $content -replace 'updateUrl=.*', 'updateUrl=https://kigili.smg.com.tr/update.txt'
	$content = $content -replace 'Subscribe=.*', 'Subscribe=0'
    
    # Dosyayı kaydet
    $content | Set-Content $configPath
    Write-Log "Config dosyası güncellendi"
    
    # Değişiklikleri kontrol et
    Write-Log "Güncellenen satırlar:"
    $content | Where-Object { $_ -match "serviceUrl|downloadURL|updateUrl" } | ForEach-Object {
        Write-Log "  $_"
    }
    
    # Config güncellendikten SONRA SMG Player process'lerini durdur
    Write-Log "Config güncellendi, şimdi SMG Player process'leri durduruluyor..."
    
    $processes = Get-Process -Name "smgplayer" -ErrorAction SilentlyContinue
    if ($processes) {
        Stop-Process -Name "smgplayer" -Force -ErrorAction SilentlyContinue
        Write-Log "SMG Player process'leri durduruldu"
        Start-Sleep -Seconds 3
    } else {
        Write-Log "SMG Player process'i bulunamadı"
    }
    
    # Alternatif taskkill komutu
    taskkill /F /IM smgplayer.exe 2>$null
    
    Write-Log "SMG Player config update başarıyla tamamlandı!"
    
} catch {
    Write-Log "HATA: $($_.Exception.Message)"
    exit 1
}

# Script başarılı olarak tamamlandı
exit 0